/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.lpar;

import com.ibm.hsc.auiml.databeans.lpar.HSCDAdapterBean;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.websm.cec.AdapterRecoverDialog;
import com.ibm.hsc.websm.cec.ResRecoverDialog;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.ValueDescriptor;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Hashtable;
import java.util.Vector;

public class HSCDAdapterBeanExt
extends HSCDAdapterBean {
    public static final String ERR_NO_SLOT_MOVE_DEST = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_SLOT_MOVE_DEST", "HMCERRV3DLPAR013: No destination LPAR is selected for I/O slot move operation.");
    public static final String ERR_NO_SLOT_SEL = HSCResourceBundleUtil.getMessage("DLPARBundle", "ERR_NO_SLOT_SEL", "HMCERRV3DLPAR014: No I/O slot is selected for DLPAR operation.");
    public static final String SLOT_LABEL = HSCResourceBundleUtil.getMessage("DLPARBundle", "SLOT_LABEL", "Slot");
    private Vector mChangableSlots;
    private Vector mFreeSlots;

    public HSCDAdapterBeanExt() {
        this.mMainPanelName = "SlotMainPanel";
        this.mAddPanelName = "SlotAddPanel";
        this.mRemovePanelName = "SlotRemovePanel";
        this.mMovePanelName = "SlotMovePanel";
        this.mTaskGroupName = "SlotTaskGroup";
        this.mAddButtonName = "SlotAddButton";
        this.mRemoveButtonName = "SlotRemoveButton";
        this.mMoveButtonName = "SlotMoveButton";
        this.mAuimlClassName = "com.ibm.hsc.auiml.databeans.lpar.DAdapter";
    }

    public void load() {
        this.m_idRemoveDrawerColumn = null;
        this.m_idAddDrawerColumn = null;
        this.loadBackendData();
        this.m_idRemoveTable = new ItemDescriptor[0];
        this.m_cdRemoveTableStructure = new ColumnDescriptor[0];
        this.m_iRemoveTableSelection = new int[0];
        this.m_sRemoveDrawerColumn = new String[0];
        this.m_sRemoveSlotColumn = new String[0];
        this.m_sRemoveTypeColumn = new String[0];
        this.m_idFreeTable = new ItemDescriptor[0];
        this.m_cdFreeTableStructure = new ColumnDescriptor[0];
        this.m_iFreeTableSelection = new int[0];
        this.m_sAddDrawerColumn = new String[0];
        this.m_sAddSlotColumn = new String[0];
        this.m_sAddTypeColumn = new String[0];
        this.m_idMoveTable = new ItemDescriptor[0];
        this.m_cdMoveTableStructure = new ColumnDescriptor[0];
        this.m_iMoveTableSelection = new int[0];
        this.m_sMoveDrawerColumn = new String[0];
        this.m_sMoveSlotColumn = new String[0];
        this.m_sMoveTypeColumn = new String[0];
        this.m_dDetail = 0.0;
        this.m_cdDetail = new ValueDescriptor[0];
        this.m_dTimeout = 0.0;
        this.m_cdTimeout = new ValueDescriptor[0];
    }

    private void loadBackendData() {
        try {
            Hashtable hashtable = this.loadDataFromServer("getDLPARIOSlotData");
            if (hashtable == null) {
                return;
            }
            this.mChangableSlots = (Vector)hashtable.get("changableSlots");
            if (this.mChangableSlots == null || this.mChangableSlots.size() == 0) {
                this.mDisableMove = true;
                this.mDisableRemove = true;
            }
            this.mFreeSlots = (Vector)hashtable.get("freeSlots");
            if (this.mFreeSlots == null || this.mFreeSlots.size() == 0) {
                this.mDisableAdd = true;
            }
            this.setSlotsData(this.mChangableSlots, false);
            this.setSlotsData(this.mFreeSlots, true);
            this.m_cdMoveDestination = this.initMoveToData(hashtable);
            if (this.m_cdMoveDestination.length > 0) {
                this.setMoveDestination((String)this.mUsrNames.elementAt(0));
            }
            this.mRecoverData = this.buildRecoverData("getSlotRecoverInfo");
            this.setAddDisable();
        }
        catch (Throwable throwable) {
            this.mLoadException = throwable;
            this.handleException(throwable);
        }
    }

    private void setSlotsData(Vector vector, boolean bl) {
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        ItemDescriptor[] itemDescriptorArray = new ItemDescriptor[n];
        ItemDescriptor[] itemDescriptorArray2 = new ItemDescriptor[n];
        ItemDescriptor[] itemDescriptorArray3 = new ItemDescriptor[n];
        if (bl) {
            this.vectorToArray(vector, itemDescriptorArray, itemDescriptorArray2, itemDescriptorArray3, "a");
            if (IDebug.enabled) {
                System.out.println("free drawerNamesArray size: " + itemDescriptorArray.length);
            }
            this.setAddDrawerColumnList(itemDescriptorArray);
            this.setAddSlotColumnList(itemDescriptorArray2);
            this.setAddTypeColumnList(itemDescriptorArray3);
        } else {
            this.vectorToArray(vector, itemDescriptorArray, itemDescriptorArray2, itemDescriptorArray3, "r");
            if (IDebug.enabled) {
                System.out.println("changable drawerNamesArray size: " + itemDescriptorArray.length);
            }
            this.setRemoveDrawerColumnList(itemDescriptorArray);
            this.setRemoveSlotColumnList(itemDescriptorArray2);
            this.setRemoveTypeColumnList(itemDescriptorArray3);
            itemDescriptorArray = new ItemDescriptor[n];
            itemDescriptorArray2 = new ItemDescriptor[n];
            itemDescriptorArray3 = new ItemDescriptor[n];
            this.vectorToArray(vector, itemDescriptorArray, itemDescriptorArray2, itemDescriptorArray3, "m");
            this.setMoveDrawerColumnList(itemDescriptorArray);
            this.setMoveSlotColumnList(itemDescriptorArray2);
            this.setMoveTypeColumnList(itemDescriptorArray3);
        }
    }

    private void vectorToArray(Vector vector, ItemDescriptor[] itemDescriptorArray, ItemDescriptor[] itemDescriptorArray2, ItemDescriptor[] itemDescriptorArray3, String string) {
        if (vector == null) {
            return;
        }
        int n = 0;
        while (n < vector.size()) {
            Hashtable hashtable = (Hashtable)vector.elementAt(n);
            String string2 = (String)hashtable.get("IODrawerDeviceID");
            itemDescriptorArray[n] = new ItemDescriptor(string + "d" + n, string2);
            Short s = (Short)hashtable.get("SlotID");
            String string3 = (String)hashtable.get("SlotLocation");
            itemDescriptorArray2[n] = new ItemDescriptor(string + "s" + n, SLOT_LABEL + s.toString() + "/" + string3);
            String string4 = (String)hashtable.get("ClassCodeInfo");
            itemDescriptorArray3[n] = new ItemDescriptor(string + "t" + n, string4);
            ++n;
        }
    }

    protected boolean saveChanges() throws Exception {
        String[] stringArray = this.getTaskGroupSelection();
        String string = null;
        String string2 = "moveSlots";
        int n = 3;
        Hashtable hashtable = null;
        if (stringArray[0].equals(this.mAddButtonName)) {
            hashtable = this.getSelInfo(this.getFreeTableSelection(), this.mFreeSlots);
            string2 = "addSlots";
        } else if (stringArray[0].equals(this.mRemoveButtonName)) {
            hashtable = this.getSelInfo(this.getRemoveTableSelection(), this.mChangableSlots);
            string2 = "removeSlots";
        } else if (stringArray[0].equals(this.mMoveButtonName)) {
            hashtable = this.getSelInfo(this.getMoveTableSelection(), this.mChangableSlots);
            ++n;
            string = this.getMoveDestination();
            if (string == null) {
                this.showInfo(ERR_NO_SLOT_MOVE_DEST, null, null);
                return false;
            }
            string = (String)this.mIntNames.elementAt(this.mUsrNames.indexOf(string));
        } else {
            return false;
        }
        if (hashtable == null || hashtable.size() < 1) {
            this.showInfo(ERR_NO_SLOT_SEL, null, null);
            return false;
        }
        short s = (short)this.getDetail();
        int n2 = (int)this.getTimeout();
        Object[] objectArray = new Object[n];
        int n3 = 0;
        objectArray[n3++] = hashtable;
        if (string != null) {
            objectArray[n3++] = string;
        }
        objectArray[n3++] = new Integer(n2);
        objectArray[n3++] = new Short(s);
        this.saveDataToServer(string2, objectArray, s <= 0);
        return true;
    }

    private Hashtable getSelInfo(int[] nArray, Vector vector) {
        Hashtable hashtable;
        int n;
        Vector vector2 = new Vector();
        Vector vector3 = new Vector();
        Vector vector4 = new Vector();
        Vector vector5 = new Vector();
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            if (IDebug.enabled) {
                System.out.println("selected ndx: " + n);
            }
            hashtable = (Hashtable)vector.elementAt(n);
            vector2.addElement(hashtable.get("IODrawerDeviceID"));
            vector5.addElement(hashtable.get("SlotLocation"));
            vector3.addElement(hashtable.get("SlotID"));
            vector4.addElement(hashtable.get("PCIBus"));
            ++n2;
        }
        n = vector2.size();
        if (n == 0) {
            return null;
        }
        hashtable = new Hashtable();
        String[] stringArray = new String[n];
        Short[] shortArray = new Short[n];
        Short[] shortArray2 = new Short[n];
        String[] stringArray2 = new String[n];
        hashtable.put("SlotLocation", vector5.toArray(stringArray2));
        hashtable.put("IODrawerDeviceID", vector2.toArray(stringArray));
        hashtable.put("SlotID", vector3.toArray(shortArray));
        hashtable.put("PCIBus", vector4.toArray(shortArray2));
        return hashtable;
    }

    public void setDynamicValues() {
        super.setDynamicValues();
        String string = this.mUsrTaskMgr.getCaptionText(this.mMainPanelName);
        this.mUsrTaskMgr.setCaptionText(this.mMainPanelName, string + " " + this.mUserDefinedName);
        this.mUsrTaskMgr.refreshAllElements();
        if (!this.mDisableAdd && this.mDisableAddControls) {
            this.mUsrTaskMgr.setEnabled(this.mAddPanelName + ".freeTable", false);
        }
        if (!this.mDisableAdd && this.mRecoverData == null) {
            this.mUsrTaskMgr.setEnabled(this.mAddPanelName + ".SlotInfoBtn", false);
        }
    }

    public ResRecoverDialog getRecoverDialogInst() {
        return AdapterRecoverDialog.getInstance();
    }
}

